<?cs include "header.cs"?>
<?cs include "macros.cs"?>

<div id="ctxtnav"></div>

<div id="content" class="mergebot">

<h1>MergeBot</h1>

<!-- DEBUG SECTION -->
<?cs if:mergebot.debug ?>
<h2>Debug info:</h2>
<?cs each:debug = mergebot.debug ?>
	<li><?cs var:debug ?></li>
<?cs /each ?>
<hr>
<?cs /if ?>
<!-- END DEBUG SECTION -->

<!-- Show all of our queues -->
<?cs each:queue = mergebot.queue ?>
	<div id="content" class="query">
	<h1><?cs var:queue ?> Queue</h1>

	<table class="listing tickets">
	<!-- Hardcode the header for now: -->
	<thead><tr>
		<th>Ticket</th>
		<th>Summary</th>
		<th>Component</th>
		<th>Version</th>
		<th>Status</th>
		<th>Requestor</th>
		<th>Activity</th> <!-- for lack of a better name -->
	</tr></thead>

	<?cs if:queue.current ?>
		<tr>
		<th><a href=<?cs var:queue.current.href ?>>#<?cs var:queue.current ?></a></th> <!-- #ticket -->
		<th><a href=<?cs var:queue.current.href ?>><?cs var:queue.current.summary ?></a></th>
		<th><?cs var:queue.current.component ?></th>
		<th><?cs var:queue.current.version ?></th>
		<th><?cs var:queue.current.status ?></th>
		<th><?cs var:queue.current.requestor ?></th>
		<th>Doing <?cs name:queue ?></th> <!-- activity -->
		</tr>
	<?cs /if ?>
	<?cs each:task = queue.queue ?> <!-- was queue.queue -->
		<tr>
		<th><a href=<?cs var:task.href ?>>#<?cs var:task ?></a></th> <!-- #ticket -->
		<th><a href=<?cs var:task.href ?>><?cs var:task.summary ?></a></th>
		<th><?cs var:task.component ?></th>
		<th><?cs var:task.version ?></th>
		<th><?cs var:task.status ?></th>
		<th><?cs var:task.requestor ?></th>
		<th><?cs var:task.mergebotstate ?></th> <!-- activity -->
		</tr>
	<?cs /each ?>

	</table>
	</div>
<?cs /each ?>

<!-- Tickets that are not in an activity queue: -->
<div id="content" class="query">
<h1>Unqueued</h1>

<table class="listing tickets">
<!-- Hardcode the header for now: -->
<thead><tr>
	<th>Ticket</th>
	<th>Summary</th>
	<th>Component</th>
	<th>Version</th>
	<th>Status</th>
	<th>MergeBotState</th>
	<th>Actions</th>
</tr></thead>

<?cs each:task = mergebot.notqueued ?>
	<tr>
	<th><a href=<?cs var:task.href ?>>#<?cs var:task ?></a></th> <!-- ticket -->
	<th><a href=<?cs var:task.href ?>><?cs var:task.summary ?></a></th> <!-- summary -->
	<th><?cs var:task.component ?></th>
	<th><?cs var:task.version ?></th>
	<th><?cs var:task.status ?></th>
	<th><?cs var:task.mergebotstate ?></th>

	<td>
	<!-- For each of the buttons, MergeBot's web_ui tells us if it's a
	valid operation for the ticket.  Use that to determine which buttons to
	show.  -->
	<form id="ops" method="post" name="ops-<?cs var:task ?>" action="">
	<input type="hidden" name="ticket" value="<?cs var:task ?>" />
	<input type="hidden" name="component" value="<?cs var:task.component ?>" />
	<input type="hidden" name="version" value="<?cs var:task.version ?>" />
	<?cs if:task.actions.branch ?>
		<input type="submit" name="action" value="Branch" />
	<?cs /if ?>
	<?cs if:task.actions.rebranch ?>
		<input type="submit" name="action" value="Rebranch" />
	<?cs /if ?>
	<?cs if:task.actions.merge ?>
		<input type="submit" name="action" value="Merge" />
	<?cs /if ?>
	<?cs if:task.actions.checkmerge ?>
		<input type="submit" name="action" value="CheckMerge" />
	<?cs /if ?>
	</form>
	</td>

	</tr>
<?cs /each ?>

</table>
</div>


</div>

<?cs include:"footer.cs"?>
