"""Implementation of the daemonizing process
from "Advanced Programming in the UNIX Environment" by W. Richard Stevens,
1993.
"""
import os
import sys

def daemonize():
    # Let's assume nothing ever goes wrong...
    pid = os.fork()
    if pid:
        sys.exit(0)
    os.setsid()
    os.chdir('/')
    os.umask(000)
    for n in range(1024):
        try:
            os.close(n)
        except OSError:
            pass
    os.open('/dev/null', os.O_RDONLY)
    os.open('/dev/null', os.O_WRONLY)
    os.dup(1)
