def _get_mergebotstate(ticket):
    if hasattr(ticket, '_old') and 'mergebotstate' in ticket._old:
        state = ticket._old['mergebotstate']
    else:
        try:
            state = ticket['mergebotstate']
        except KeyError:
            state = ""
    if state == "--":
        state = ""
    return state

# FIXME: If a ticket has another ticket as its version (#123), then we need to
# make sure that the other ticket has an existing branch ('branched' mergebot
# state) before we allow any actions.
# More accurately, we need to determine if, after all queued actions upon which
# it would depend complete successfully, that these operations would be
# allowed.
def is_branchable(ticket):
    state = _get_mergebotstate(ticket)
    return state == "" or state == "merged"

def is_rebranchable(ticket):
    # TODO: we should be able to tell if trunk (or version) has had commits
    # since we branched, and only mark it as rebranchable if there have
    # been.
    state = _get_mergebotstate(ticket)
    return state in ["branched", "conflicts"]

def is_mergeable(ticket):
    state = _get_mergebotstate(ticket)
    return state == "branched"

def is_checkmergeable(ticket):
    state = _get_mergebotstate(ticket)
    return state == "branched" or state == "conflicts"

